/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.client.render.infobar.QuestDisplayDataModel;
import dev.toma.gunsrpg.common.quests.quest.AbstractAreaBasedQuest;
import dev.toma.gunsrpg.common.quests.quest.AreaSurvivalData;
import dev.toma.gunsrpg.common.quests.quest.IQuestFactory;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.quest.SurvivalQuest;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.StringTextComponent;

public class AreaSurvivalQuest
extends AbstractAreaBasedQuest<AreaSurvivalData> {
    public static final IQuestFactory<AreaSurvivalData, AreaSurvivalQuest> FACTORY = IQuestFactory.of(AreaSurvivalQuest::new, AreaSurvivalQuest::new);
    private int timeLeft;

    public AreaSurvivalQuest(QuestScheme<AreaSurvivalData> scheme, UUID traderId) {
        super(scheme, traderId);
        this.timeLeft = ((AreaSurvivalData)this.getActiveData()).getTicks();
    }

    public AreaSurvivalQuest(QuestDeserializationContext<AreaSurvivalData> context) {
        super(context);
    }

    @Override
    protected void fillDataModel(QuestDisplayDataModel model) {
        super.fillDataModel(model);
        Interval.IFormatFactory formatFactory = f -> f.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND).compact();
        model.addInformationRow(SurvivalQuest.TIME_REMAINING, this, q -> new StringTextComponent(Interval.format(q.timeLeft, formatFactory)));
        this.fillAreaDataModel(model);
        model.addConditionDisplay(this);
    }

    @Override
    protected void writeAdditionalData(CompoundNBT nbt) {
        nbt.func_74768_a("timeLeft", this.timeLeft);
    }

    @Override
    protected void readAddtionalData(CompoundNBT nbt) {
        this.timeLeft = nbt.func_74762_e("timeLeft");
    }

    @Override
    protected void handleSuccessfulTick(Trigger trigger, IPropertyReader reader) {
        if (--this.timeLeft < 0) {
            this.setStatus(QuestStatus.COMPLETED);
        }
    }
}

